(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     84774,       2129]*)
(*NotebookOutlinePosition[     85674,       2159]*)
(*  CellTagsIndexPosition[     85630,       2155]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData["Simple Oscillation"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
There follows unembellished code that produces examples and figures \
from section 6.1.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Example 6.1M", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"soln", "=", 
      RowBox[{"DSolve", "[", 
        RowBox[{
          RowBox[{"{", 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    SuperscriptBox["x", "\[DoublePrime]",
                      MultilineFunction->None], "[", "t", "]"}], 
                  "+", \(16\ x[t]\)}], "==", "0"}], ",", \(x[0] == 3\), ",", 
              RowBox[{
                RowBox[{
                  SuperscriptBox["x", "\[Prime]",
                    MultilineFunction->None], "[", "0", "]"}], "==", "0"}]}], 
            "}"}], ",", \(x[t]\), ",", "t"}], "]"}]}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{x[t] \[Rule] 3\ Cos[4\ t]}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(s1[t_] = 
      x[t] /. soln\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(3\ Cos[4\ t]\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 6.2 M", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"soln", "=", 
      RowBox[{"DSolve", "[", 
        RowBox[{
          RowBox[{"{", 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    SuperscriptBox["x", "\[DoublePrime]",
                      MultilineFunction->None], "[", "t", "]"}], 
                  "+", \(192\ x[t]\)}], "==", "0"}], ",", \(x[0] == 1\/4\), 
              ",", 
              RowBox[{
                RowBox[{
                  SuperscriptBox["x", "\[Prime]",
                    MultilineFunction->None], "[", "0", "]"}], "==", "0"}]}], 
            "}"}], ",", \(x[t]\), ",", "t"}], "]"}]}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{x[t] \[Rule] 1\/4\ Cos[8\ \@3\ t]}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(s2[t_] = 
      x[t] /. soln\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(1\/4\ Cos[8\ \@3\ t]\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Amplitude & Phase angle (Figure 6.2)", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(p = 
        Plot[Sin[t + \[Pi]\/4], {t, \(-\(\[Pi]\/2\)\), \(3\ \[Pi]\)\/2}, 
          Ticks \[Rule] {{{\(-\(\[Pi]\/4\)\), "\<\>"}, {\[Pi]\/4, "\<\>"}, {\
\[Pi]\/2, "\<\>"}, {\(3\ \[Pi]\)\/4, "\<\>"}}, {{\(-1\), "\<-A\>"}, {1, \
"\<A\>"}}}, AxesLabel \[Rule] {"\<t\>", "\<Down\>"}];\)\)], "Input",
  AspectRatioFixed->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.151576 0.309017 0.294302 [
[1.025 .30902 0 -6 ]
[1.025 .30902 10 6 ]
[.2494 .01471 -16.0625 -6 ]
[.2494 .01471 0 6 ]
[.2494 .60332 -10.0625 -6 ]
[.2494 .60332 0 6 ]
[.2619 .64303 -14 0 ]
[.2619 .64303 14 12 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.14286 .30902 m
.14286 .31527 L
s
.38095 .30902 m
.38095 .31527 L
s
.5 .30902 m
.5 .31527 L
s
.61905 .30902 m
.61905 .31527 L
s
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.2619 .01471 m
.26815 .01471 L
s
gsave
.2494 .01471 -77.0625 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(A) show
75.062 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.2619 .60332 m
.26815 .60332 L
s
gsave
.2494 .60332 -71.0625 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(A) show
69.062 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.2619 0 m
.2619 .61803 L
s
gsave
.2619 .64303 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Down) show
87.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .10091 m
.06244 .16011 L
.10458 .23548 L
.14415 .31153 L
.18221 .38457 L
.22272 .457 L
.26171 .51685 L
.28158 .54231 L
.30316 .5654 L
.32392 .58273 L
.33381 .5892 L
.34309 .59418 L
.35211 .59801 L
.35675 .59957 L
.36181 .60098 L
.36467 .60162 L
.36733 .60213 L
.37009 .60256 L
.37258 .60287 L
.37376 .60299 L
.37504 .6031 L
.37614 .60317 L
.37735 .60324 L
.37864 .60328 L
.37934 .6033 L
.38 .60331 L
.38118 .60332 L
.38244 .60331 L
.38365 .60327 L
.38435 .60325 L
.385 .60321 L
.38631 .60314 L
.38772 .60303 L
.39027 .60276 L
.39261 .60245 L
.398 .60146 L
.40368 .60002 L
.41329 .59665 L
.4238 .59164 L
.44341 .57869 L
.46436 .55988 L
.50586 .50893 L
.54584 .4457 L
.5843 .37589 L
.62522 .29703 L
.66463 .22185 L
.70251 .15503 L
.74285 .09449 L
.78168 .05044 L
.79181 .04163 L
Mistroke
.80285 .03339 L
.8134 .02688 L
.82295 .02217 L
.82784 .0202 L
.83311 .01841 L
.83767 .01714 L
.84267 .01606 L
.84542 .01559 L
.84799 .01525 L
.8507 .01498 L
.85222 .01487 L
.85289 .01483 L
.8536 .0148 L
.85489 .01475 L
.85608 .01472 L
.85736 .01472 L
.85808 .01472 L
.85877 .01473 L
.85999 .01477 L
.86112 .01482 L
.86235 .01489 L
.86365 .01499 L
.86623 .01524 L
.86867 .01557 L
.87322 .01637 L
.87812 .01753 L
.88343 .01913 L
.893 .02291 L
.90181 .0274 L
.92061 .04014 L
.94127 .05889 L
.97619 .10091 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.812, 174.188},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000[R000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00BOooool00ol0003oooooooooo`3=ooooo`00?_oo
ool2o`000004ooooool0003o0000o`0000Gooooo00?o0000ooooooooool0cOooool003kooooo00Go
0000ooooooooooooooooo`000006ooooo`03o`000?oooooooooo0<gooooo000iooooo`Co000000?o
ooooo`000?l000000ol00006ooooo`?o0000S_ooool5o`0003[ooooo000oooooo`03o`000?oooooo
000000Oooooo00?o0000ooooooooool0R_ooool4o`0000Gooooo1_l0000dooooo`00?oooool00ol0
003oooooo`000007ooooo`03o`000?oooooooooo08Oooooo0ol0000?ooooo`;o0000<_ooool0043o
oooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`25ooooo`;o00005?ooool2o`00033o
oooo000oooooo`;o00002?ooool00ol0003oooooooooo`24ooooo`03o`000?oooooooooo01Kooooo
00?o0000ooooooooool0;Oooool004Wooooo00?o0000ooooooooool0P_ooool2o`0001[ooooo00?o
0000ooooooooool0;?ooool004Wooooo00?o0000ooooooooool0POooool00ol0003oooooooooo`0K
ooooo`03o`000?oooooooooo02_ooooo0019ooooo`03o`000?oooooooooo07oooooo0_l0000Ooooo
o`;o0000:oooool004Wooooo00?o0000ooooooooool0O_ooool00ol0003oooooooooo`0Qooooo`03
o`000?oooooooooo02Sooooo0019ooooo`03o`000?oooooooooo07gooooo00?o0000ooooooooool0
8oooool00ol0003oooooooooo`0Wooooo`00BOooool00ol0003oooooooooo`1mooooo`03o`000?oo
oooooooo02Cooooo00?o0000ooooooooool09_ooool004Wooooo00?o0000ooooooooool0O?ooool0
0ol0003oooooooooo`0Vooooo`03o`000?oooooooooo02Gooooo0019ooooo`03o`000?oooooooooo
07_ooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0Uooooo`00BOooool00ol0003o
ooooooooo`1jooooo`03o`000?oooooooooo02Wooooo00?o0000ooooooooool09?ooool004Wooooo
00?o0000ooooooooool0NOooool00ol0003oooooooooo`0[ooooo`03o`000?oooooooooo02?ooooo
0019ooooo`03o`000?oooooooooo07Sooooo00?o0000ooooooooool0;Oooool00ol0003ooooooooo
o`0Rooooo`00BOooool00ol0003oooooooooo`1hooooo`03o`000?oooooooooo02gooooo00?o0000
ooooooooool08_ooool004Wooooo00?o0000ooooooooool0Moooool00ol0003oooooooooo`0_oooo
o`03o`000?oooooooooo027ooooo0019ooooo`03o`000?oooooooooo07Kooooo00?o0000oooooooo
ool0<Oooool00ol0003oooooooooo`0Pooooo`00BOooool00ol0003oooooooooo`1eooooo`03o`00
0?oooooooooo03;ooooo00?o0000ooooooooool08?ooool004Wooooo00?o0000ooooooooool0M?oo
ool00ol0003oooooooooo`0dooooo`03o`000?oooooooooo01oooooo0019ooooo`03o`000?oooooo
oooo07Cooooo00?o0000ooooooooool0=Oooool00ol0003oooooooooo`0Nooooo`003_ooool00ol0
003oooooooooo`0hooooo`03o`000?oooooooooo07?ooooo00?o0000ooooooooool0=oooool00ol0
003oooooooooo`0Mooooo`003_ooool00ol0003oooooooooo`0hooooo`03o`000?oooooooooo07;o
oooo00?o0000ooooooooool0F?ooool000oooooo00?o0000ooooooooool0=oooool00ol0003ooooo
ooooo`1booooo`03o`000?oooooooooo05Sooooo000@ooooo`03o`000?oooooooooo03Kooooo00?o
0000ooooooooool0LOooool00ol0003oooooooooo`1Iooooo`004Oooool00ol0003oooooooooo`0e
ooooo`03o`000?oooooooooo073ooooo00?o0000ooooooooool0F_ooool0017ooooo00?o0000oooo
ooooool0=Oooool00ol0003oooooooooo`1`ooooo`03o`000?oooooooooo05[ooooo000Booooo`03
o`000?oooooooooo03Cooooo00?o0000ooooooooool0Koooool00ol0003oooooooooo`1Kooooo`00
4oooool00ol0003oooooooooo`0cooooo`03o`000?oooooooooo06kooooo00?o0000ooooooooool0
G?ooool001?ooooo00?o0000ooooooooool0<oooool00ol0003oooooooooo`1^ooooo`03o`000?oo
oooooooo05cooooo000Dooooo`03o`000?oooooooooo03;ooooo00?o0000ooooooooool0KOooool0
0ol0003oooooooooo`1Mooooo`005Oooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo
06cooooo00?o0000ooooooooool0G_ooool001Kooooo00?o0000ooooooooool0<?ooool00ol0003o
ooooooooo`1/ooooo`03o`000?oooooooooo05kooooo000Fooooo`03o`000?oooooooooo033ooooo
00?o0000ooooooooool0Joooool00ol0003oooooooooo`1Oooooo`005oooool00ol0003ooooooooo
o`0_ooooo`03o`000?oooooooooo06[ooooo00?o0000ooooooooool0H?ooool001Sooooo00?o0000
ooooooooool0;_ooool00ol0003oooooooooo`1Zooooo`03o`000?oooooooooo063ooooo000Hoooo
o`03o`000?oooooooooo02kooooo00?o0000ooooooooool0JOooool00ol0003oooooooooo`1Qoooo
o`006Oooool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo06Sooooo00?o0000oooooooo
ool0H_ooool001Wooooo00?o0000ooooooooool0;Oooool00ol0003oooooooooo`1Xooooo`03o`00
0?oooooooooo06;ooooo000Jooooo`03o`000?oooooooooo02cooooo00?o0000ooooooooool0Iooo
ool00ol0003oooooooooo`1Sooooo`006_ooool00ol0003oooooooooo`0/ooooo`03o`000?oooooo
oooo06Oooooo00?o0000ooooooooool0Hoooool001_ooooo00?o0000ooooooooool0:oooool00ol0
003oooooooooo`1Vooooo`03o`000?oooooooooo06Cooooo000Kooooo`03o`000?oooooooooo02_o
oooo00?o0000ooooooooool0IOooool00ol0003oooooooooo`1Uooooo`007?ooool00ol0003ooooo
ooooo`0Zooooo`03o`000?oooooooooo06Gooooo00?o0000ooooooooool0IOooool001cooooo00?o
0000ooooooooool0:_ooool00ol0003oooooooooo`1Tooooo`03o`000?oooooooooo06Kooooo000M
ooooo`03o`000?oooooooooo02Wooooo00?o0000ooooooooool0Hoooool00ol0003oooooooooo`1W
ooooo`007_ooool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo06?ooooo00?o0000oooo
ooooool0Ioooool001kooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`1Rooooo`03
o`000?oooooooooo06Sooooo000Oooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool0
H_ooool00ol0003oooooooooo`1Xooooo`007oooool00ol0003oooooooooo`0Wooooo`03o`000?oo
oooooooo067ooooo00?o0000ooooooooool0JOooool0023ooooo00?o0000ooooooooool09_ooool0
0ol0003oooooooooo`1Pooooo`03o`000?oooooooooo06[ooooo000Pooooo`03o`000?oooooooooo
02Kooooo00?o0000ooooooooool0H?ooool00ol0003oooooooooo`1Zooooo`008Oooool00ol0003o
ooooooooo`0Uooooo`03o`000?oooooooooo05oooooo00?o0000ooooooooool0Joooool0027ooooo
00?o0000ooooooooool09Oooool00ol0003oooooooooo`1Oooooo`03o`000?oooooooooo06_ooooo
000Rooooo`03o`000?oooooooooo02Cooooo00?o0000ooooooooool0G_ooool00ol0003ooooooooo
o`1/ooooo`008_ooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo05kooooo00?o0000
ooooooooool0K?ooool002?ooooo00?o0000ooooooooool08oooool00ol0003oooooooooo`1Moooo
o`03o`000?oooooooooo06gooooo000Sooooo`03o`000?oooooooooo02?ooooo00?o0000oooooooo
ool0GOooool00ol0003oooooooooo`1]ooooo`009?ooool00ol0003oooooooooo`0Rooooo`03o`00
0?oooooooooo05cooooo00?o0000ooooooooool0K_ooool002Cooooo00?o0000ooooooooool08_oo
ool00ol0003oooooooooo`1Looooo`03o`000?oooooooooo06kooooo000Uooooo`03o`000?oooooo
oooo027ooooo00?o0000ooooooooool0Foooool00ol0003oooooooooo`1_ooooo`009Oooool00ol0
003oooooooooo`0Qooooo`03o`000?oooooooooo05_ooooo00?o0000ooooooooool0Koooool002Ko
oooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`1Kooooo`03o`000?oooooooooo06oo
oooo000Vooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool0F_ooool00ol0003ooooo
ooooo`1`ooooo`009oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo05[ooooo00?o
0000ooooooooool0L?ooool002Sooooo00?o0000ooooooooool07_ooool00ol0003oooooooooo`1I
ooooo`03o`000?oooooooooo077ooooo000Xooooo`03o`000?oooooooooo01kooooo00?o0000oooo
ooooool0FOooool00ol0003oooooooooo`1aooooo`00:Oooool00ol0003oooooooooo`0Mooooo`03
o`000?oooooooooo05Sooooo00?o0000ooooooooool0L_ooool002Wooooo00?o0000ooooooooool0
7Oooool00ol0003oooooooooo`1Hooooo`03o`000?oooooooooo07;ooooo000Zooooo`03o`000?oo
oooooooo01cooooo00?o0000ooooooooool0Eoooool00ol0003oooooooooo`1cooooo`00:_ooool0
0ol0003oooooooooo`0Looooo`03o`000?oooooooooo05Oooooo00?o0000ooooooooool0Hoooool2
o`0000kooooo000[ooooo`03o`000?oooooooooo01_ooooo00?o0000ooooooooool0E_ooool00ol0
003oooooooooo`1Sooooo`04o`000?ooooooooooo`0000gooooo0008ooooooSo00002?ooool00ol0
003oooooooooo`0>ooooo`00;?ooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo01[o
oooo00?o0000ooooooooool06oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo06Co
oooo00?o0000ooooooooool03_ooool002cooooo00?o0000ooooooooool06_ooool00ol0003ooooo
ooooo`0Jooooo`03o`000?oooooooooo01_ooooo00?o0000ooooooooool06_ooool00ol0003ooooo
ooooo`1Sooooo`Co00003_ooool002gooooo00?o0000ooooooooool06Oooool00ol0003ooooooooo
o`1Dooooo`03o`000?oooooooooo06Gooooo00?o0000ooooooooool03_ooool002gooooo00?o0000
ooooooooool06Oooool00ol0003oooooooooo`1Dooooo`03o`000?oooooooooo06Gooooo00?o0000
ooooooooool03_ooool002kooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`1Coooo
o`03o`000?oooooooooo07Oooooo000^ooooo`03o`000?oooooooooo01Sooooo00?o0000oooooooo
ool0Doooool00ol0003oooooooooo`1gooooo`00;oooool00ol0003oooooooooo`0Gooooo`03o`00
0?oooooooooo05;ooooo00?o0000ooooooooool0N?ooool002oooooo00?o0000ooooooooool05ooo
ool00ol0003oooooooooo`1Booooo`03o`000?oooooooooo07Sooooo000`ooooo`03o`000?oooooo
oooo01Kooooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`1iooooo`00<?ooool00ol0
003oooooooooo`0Fooooo`03o`000?oooooooooo057ooooo00?o0000ooooooooool0NOooool0037o
oooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`1@ooooo`03o`000?oooooooooo07[o
oooo000aooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0D?ooool00ol0003ooooo
ooooo`1jooooo`00<_ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo04oooooo00?o
0000ooooooooool0Noooool003;ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`1?
ooooo`03o`000?oooooooooo07_ooooo000cooooo`03o`000?oooooooooo01?ooooo00?o0000oooo
ooooool0C_ooool00ol0003oooooooooo`1looooo`00<oooool00ol0003oooooooooo`0Cooooo`03
o`000?oooooooooo04kooooo00?o0000ooooooooool0O?ooool003Cooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`1=ooooo`03o`000?oooooooooo07gooooo000dooooo`03o`000?oo
oooooooo01;ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`1mooooo`00=Oooool0
0ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04cooooo00?o0000ooooooooool0O_ooool0
03Gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1<ooooo`03o`000?oooooooooo
07kooooo000fooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0Boooool00ol0003o
ooooooooo`1oooooo`00=_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo04[ooooo
00?o0000ooooooooool0P?ooool003Oooooo00?o0000ooooooooool03oooool00ol0003ooooooooo
o`1:ooooo`03o`000?oooooooooo083ooooo000hooooo`03o`000?oooooooooo00kooooo00?o0000
ooooooooool0BOooool00ol0003oooooooooo`21ooooo`00>?ooool00ol0003oooooooooo`0>oooo
o`03o`000?oooooooooo04Wooooo00?o0000ooooooooool0POooool003Wooooo00?o0000oooooooo
ool03Oooool00ol0003oooooooooo`18ooooo`03o`000?oooooooooo08;ooooo000iooooo`03o`00
0?oooooooooo00gooooo00?o0000ooooooooool0Aoooool00ol0003oooooooooo`23ooooo`00>_oo
ool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo04Oooooo00?o0000ooooooooool0Pooo
ool003[ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`16ooooo`03o`000?oooooo
oooo08Cooooo000kooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0A_ooool00ol0
003oooooooooo`24ooooo`00>oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo04Go
oooo00?o0000ooooooooool0QOooool003cooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`14ooooo`03o`000?oooooooooo08Kooooo000mooooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool0A?ooool00ol0003oooooooooo`26ooooo`00?Oooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo04?ooooo00?o0000ooooooooool0Qoooool003kooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`13ooooo`03o`000?oooooooooo08Oooooo000nooooo`03
o`000?oooooooooo00Sooooo00?o0000ooooooooool0@_ooool00ol0003oooooooooo`28ooooo`00
?oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0
ROooool003oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`11ooooo`03o`000?oo
oooooooo08Wooooo0010ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0@?ooool0
0ol0003oooooooooo`2:ooooo`00@Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
03oooooo00?o0000ooooooooool0Roooool004;ooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`0oooooo`03o`000?oooooooooo08_ooooo0012ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool0?_ooool00ol0003oooooooooo`2<ooooo`00@oooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo03gooooo00?o0000ooooooooool0SOooool004Cooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`0mooooo`03o`000?oooooooooo08gooooo0014oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`2>oooo
o`00AOooool01Ol0003ooooooooooooooooo000003gooooo00?o0000ooooooooool0Soooool004Ko
oooo00Co0000oooooooooooo0000?Oooool00ol0003oooooooooo`2?ooooo`00Aoooool00ol0003o
ooooo`00000looooo`03o`000?oooooooooo093ooooo0017ooooo`03o`000?oooooo000003_ooooo
00?o0000ooooooooool0TOooool004Sooooo0_l0000kooooo`03o`000?oooooooooo097ooooo0019
ooooo`03o`000?oooooooooo03Sooooo00?o0000ooooooooool0T_ooool004Wooooo00?o0000oooo
ooooool0=oooool00ol0003oooooooooo`2Cooooo`00BOooool2o`0003Oooooo00?o0000oooooooo
ool0U?ooool004Wooooo00?o0000ooooool00000=_ooool00ol0003oooooooooo`2Dooooo`00BOoo
ool01?l0003oooooooooool0000dooooo`03o`000?oooooooooo09Gooooo0019ooooo`04o`000?oo
ooooooooo`0003?ooooo00?o0000ooooooooool0U_ooool004Wooooo00Go0000oooooooooooooooo
o`00000aooooo`03o`000?oooooooooo09Oooooo0019ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool0;Oooool00ol0003oooooooooo`2Hooooo`00BOooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo02cooooo00?o0000ooooooooool0V?ooool004Wooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0Zooooo`03o`000?oooooooooo09Wooooo0019ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`2Jooooo`00
BOooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool0
Voooool004Wooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Tooooo`03o`000?oo
oooooooo09cooooo0019ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool08_ooool0
0ol0003oooooooooo`2Mooooo`00BOooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
023ooooo00?o0000ooooooooool0W_ooool004Wooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`0Nooooo`03o`000?oooooooooo09oooooo0019ooooo`03o`000?oooooooooo00_ooooo
00?o0000ooooooooool06oooool2o`000:;ooooo0019ooooo`03o`000?oooooooooo00cooooo0ol0
000Hooooo`;o0000Y?ooool004Wooooo00?o0000ooooooooool03oooool2o`0001Gooooo00?o0000
ooooooooool0Y?ooool004Wooooo00?o0000ooooooooool04Oooool2o`00017ooooo0_l0002Woooo
o`00?_ooool2o`000004ooooool0003o0000o`0000Gooooo00?o0000ooooooooool04oooool00ol0
003oooooooooo`0;ooooo`?o0000ZOooool003kooooo00Go0000ooooooooooooooooo`000006oooo
o`03o`000?oooooooooo01Cooooo1?l00005ooooo`Co0000[?ooool003kooooo1Ol00006ooooo`?o
00006?ooool6o`000:oooooo000oooooo`03o`000?oooooo000000Oooooo00?o0000ooooooooool0
cOooool003oooooo00?o0000ooooool000001oooool00ol0003oooooooooo`3=ooooo`00@?ooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo0<gooooo000oooooo`;o0000f?ooool00?oo
oooo6_ooool00?oooooo6_ooool00?oooooo6_ooool00?oooooo6_ooool00?oooooo6_ooool00?oo
oooo6_ooool00?oooooo6_ooool00?oooooo6_ooool003gooooo1?l00003ooooo`?o00000oooool0
0ol0003oooooo`000002ooooo`?o000000?oooooo`000?l00000a?ooool003kooooo00Ko0000oooo
oooooooo0000ooooool00003ooooo`06o`000?ooooooooooo`000?oooooo00000oooool01?l0003o
ooooooooool00035ooooo`00?_ooool01_l0003oooooooooool0003oooooo`0000?ooooo00Oo0000
ooooool0003oooooo`000?oooooo000000;ooooo00Co0000oooooooooooo0000aOooool003kooooo
00Ko0000oooooooooooo0000ooooool00003ooooo`07o`000?oooooo0000ooooool0003oooooo`00
0002ooooo`04o`000?ooooooooooo`000<Gooooo000nooooo`04o`000?ooooooooooo`0000;ooooo
0ol00002ooooo`[o0000a_ooool003kooooo00Co0000oooooooooooo0000eoooool003gooooo1?l0
003Hooooo`00oooooolJooooo`00oooooolJooooo`00\
\>"],
  ImageRangeCache->{{{0, 280.812}, {173.188, 0}} -> {-1.96364, -1.08257, \
0.0267115, 0.0137574}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[p, 
        Graphics[{Text[
              FontForm["\<(-f/w,0)\>", {"\<Symbol\>", 
                  12}], {\(-\(\[Pi]\/4\)\),  .2}, {1, 0}], PointSize[0.02], 
            Point[{\(-\(\[Pi]\/4\)\), 0}]}]];\)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.151576 0.309017 0.294302 [
[1.025 .30902 0 -6 ]
[1.025 .30902 10 6 ]
[.2494 .01471 -16.0625 -6 ]
[.2494 .01471 0 6 ]
[.2494 .60332 -10.0625 -6 ]
[.2494 .60332 0 6 ]
[.2619 .64303 -14 0 ]
[.2619 .64303 14 12 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.14286 .30902 m
.14286 .31527 L
s
.38095 .30902 m
.38095 .31527 L
s
.5 .30902 m
.5 .31527 L
s
.61905 .30902 m
.61905 .31527 L
s
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.2619 .01471 m
.26815 .01471 L
s
gsave
.2494 .01471 -77.0625 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(A) show
75.062 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.2619 .60332 m
.26815 .60332 L
s
gsave
.2494 .60332 -71.0625 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(A) show
69.062 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.2619 0 m
.2619 .61803 L
s
gsave
.2619 .64303 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Down) show
87.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .10091 m
.06244 .16011 L
.10458 .23548 L
.14415 .31153 L
.18221 .38457 L
.22272 .457 L
.26171 .51685 L
.28158 .54231 L
.30316 .5654 L
.32392 .58273 L
.33381 .5892 L
.34309 .59418 L
.35211 .59801 L
.35675 .59957 L
.36181 .60098 L
.36467 .60162 L
.36733 .60213 L
.37009 .60256 L
.37258 .60287 L
.37376 .60299 L
.37504 .6031 L
.37614 .60317 L
.37735 .60324 L
.37864 .60328 L
.37934 .6033 L
.38 .60331 L
.38118 .60332 L
.38244 .60331 L
.38365 .60327 L
.38435 .60325 L
.385 .60321 L
.38631 .60314 L
.38772 .60303 L
.39027 .60276 L
.39261 .60245 L
.398 .60146 L
.40368 .60002 L
.41329 .59665 L
.4238 .59164 L
.44341 .57869 L
.46436 .55988 L
.50586 .50893 L
.54584 .4457 L
.5843 .37589 L
.62522 .29703 L
.66463 .22185 L
.70251 .15503 L
.74285 .09449 L
.78168 .05044 L
.79181 .04163 L
Mistroke
.80285 .03339 L
.8134 .02688 L
.82295 .02217 L
.82784 .0202 L
.83311 .01841 L
.83767 .01714 L
.84267 .01606 L
.84542 .01559 L
.84799 .01525 L
.8507 .01498 L
.85222 .01487 L
.85289 .01483 L
.8536 .0148 L
.85489 .01475 L
.85608 .01472 L
.85736 .01472 L
.85808 .01472 L
.85877 .01473 L
.85999 .01477 L
.86112 .01482 L
.86235 .01489 L
.86365 .01499 L
.86623 .01524 L
.86867 .01557 L
.87322 .01637 L
.87812 .01753 L
.88343 .01913 L
.893 .02291 L
.90181 .0274 L
.92061 .04014 L
.94127 .05889 L
.97619 .10091 L
Mfstroke
gsave
.14286 .36788 -107.562 -11.25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.5 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.500 moveto
%%IncludeResource: font Symbol
%%IncludeFont: Symbol
/Symbol findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 13.500 moveto
(H) show
66.812 13.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
74.500 13.500 moveto
%%IncludeResource: font Symbol
%%IncludeFont: Symbol
/Symbol findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
80.750 13.500 moveto
(\\220) show
84.562 13.500 moveto
%%IncludeResource: font Symbol
%%IncludeFont: Symbol
/Symbol findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
92.750 13.500 moveto
%%IncludeResource: font Symbol
%%IncludeFont: Symbol
/Symbol findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(,) show
95.750 13.500 moveto
%%IncludeResource: font Symbol
%%IncludeFont: Symbol
/Symbol findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
101.750 13.500 moveto
(L) show
105.562 13.500 moveto
%%IncludeResource: font Symbol
%%IncludeFont: Symbol
/Symbol findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02 w
.14286 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.812, 174.188},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000[R000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00BOooool00ol0003oooooooooo`3=ooooo`00?_oo
ool2o`000004ooooool0003o0000o`0000Gooooo00?o0000ooooooooool0cOooool003kooooo00Go
0000ooooooooooooooooo`000006ooooo`03o`000?oooooooooo0<gooooo000iooooo`Co000000?o
ooooo`000?l000000ol00006ooooo`?o0000S_ooool5o`0003[ooooo000oooooo`03o`000?oooooo
000000Oooooo00?o0000ooooooooool0R_ooool4o`0000Gooooo1_l0000dooooo`00?oooool00ol0
003oooooo`000007ooooo`03o`000?oooooooooo08Oooooo0ol0000?ooooo`;o0000<_ooool0043o
oooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`25ooooo`;o00005?ooool2o`00033o
oooo000oooooo`;o00002?ooool00ol0003oooooooooo`24ooooo`03o`000?oooooooooo01Kooooo
00?o0000ooooooooool0;Oooool004Wooooo00?o0000ooooooooool0P_ooool2o`0001[ooooo00?o
0000ooooooooool0;?ooool004Wooooo00?o0000ooooooooool0POooool00ol0003oooooooooo`0K
ooooo`03o`000?oooooooooo02_ooooo0019ooooo`03o`000?oooooooooo07oooooo0_l0000Ooooo
o`;o0000:oooool004Wooooo00?o0000ooooooooool0O_ooool00ol0003oooooooooo`0Qooooo`03
o`000?oooooooooo02Sooooo0019ooooo`03o`000?oooooooooo07gooooo00?o0000ooooooooool0
8oooool00ol0003oooooooooo`0Wooooo`00BOooool00ol0003oooooooooo`1mooooo`03o`000?oo
oooooooo02Cooooo00?o0000ooooooooool09_ooool004Wooooo00?o0000ooooooooool0O?ooool0
0ol0003oooooooooo`0Vooooo`03o`000?oooooooooo02Gooooo0019ooooo`03o`000?oooooooooo
07_ooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0Uooooo`00BOooool00ol0003o
ooooooooo`1jooooo`03o`000?oooooooooo02Wooooo00?o0000ooooooooool09?ooool004Wooooo
00?o0000ooooooooool0NOooool00ol0003oooooooooo`0[ooooo`03o`000?oooooooooo02?ooooo
0019ooooo`03o`000?oooooooooo07Sooooo00?o0000ooooooooool0;Oooool00ol0003ooooooooo
o`0Rooooo`00BOooool00ol0003oooooooooo`1hooooo`03o`000?oooooooooo02gooooo00?o0000
ooooooooool08_ooool004Wooooo00?o0000ooooooooool0Moooool00ol0003oooooooooo`0_oooo
o`03o`000?oooooooooo027ooooo0019ooooo`03o`000?oooooooooo07Kooooo00?o0000oooooooo
ool0<Oooool00ol0003oooooooooo`0Pooooo`00BOooool00ol0003oooooooooo`1eooooo`03o`00
0?oooooooooo03;ooooo00?o0000ooooooooool08?ooool004Wooooo00?o0000ooooooooool0M?oo
ool00ol0003oooooooooo`0dooooo`03o`000?oooooooooo01oooooo0019ooooo`03o`000?oooooo
oooo07Cooooo00?o0000ooooooooool0=Oooool00ol0003oooooooooo`0Nooooo`003_ooool00ol0
003oooooooooo`0hooooo`03o`000?oooooooooo07?ooooo00?o0000ooooooooool0=oooool00ol0
003oooooooooo`0Mooooo`003_ooool00ol0003oooooooooo`0hooooo`03o`000?oooooooooo07;o
oooo00?o0000ooooooooool0F?ooool000oooooo00?o0000ooooooooool0=oooool00ol0003ooooo
ooooo`1booooo`03o`000?oooooooooo05Sooooo000@ooooo`03o`000?oooooooooo03Kooooo00?o
0000ooooooooool0LOooool00ol0003oooooooooo`1Iooooo`004Oooool00ol0003oooooooooo`0e
ooooo`03o`000?oooooooooo073ooooo00?o0000ooooooooool0F_ooool0017ooooo00?o0000oooo
ooooool0=Oooool00ol0003oooooooooo`1`ooooo`03o`000?oooooooooo05[ooooo000Booooo`03
o`000?oooooooooo03Cooooo00?o0000ooooooooool0Koooool00ol0003oooooooooo`1Kooooo`00
4oooool00ol0003oooooooooo`0cooooo`03o`000?oooooooooo06kooooo00?o0000ooooooooool0
G?ooool001?ooooo00?o0000ooooooooool0<oooool00ol0003oooooooooo`1^ooooo`03o`000?oo
oooooooo05cooooo000Dooooo`03o`000?oooooooooo03;ooooo00?o0000ooooooooool0KOooool0
0ol0003oooooooooo`1Mooooo`005Oooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo
06cooooo00?o0000ooooooooool0G_ooool001Kooooo00?o0000ooooooooool0<?ooool00ol0003o
ooooooooo`1/ooooo`03o`000?oooooooooo05kooooo000Fooooo`03o`000?oooooooooo033ooooo
00?o0000ooooooooool0Joooool00ol0003oooooooooo`1Oooooo`005oooool00ol0003ooooooooo
o`0_ooooo`03o`000?oooooooooo06[ooooo00?o0000ooooooooool0H?ooool001Sooooo00?o0000
ooooooooool0;_ooool00ol0003oooooooooo`1Zooooo`03o`000?oooooooooo063ooooo000Hoooo
o`03o`000?oooooooooo02kooooo00?o0000ooooooooool0JOooool00ol0003oooooooooo`1Qoooo
o`006Oooool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo06Sooooo00?o0000oooooooo
ool0H_ooool001Wooooo00?o0000ooooooooool0;Oooool00ol0003oooooooooo`1Xooooo`03o`00
0?oooooooooo06;ooooo000Jooooo`03o`000?oooooooooo02cooooo00?o0000ooooooooool0Iooo
ool00ol0003oooooooooo`1Sooooo`006_ooool00ol0003oooooooooo`0/ooooo`03o`000?oooooo
oooo06Oooooo00?o0000ooooooooool0Hoooool001_ooooo00?o0000ooooooooool0:oooool00ol0
003oooooooooo`1Vooooo`03o`000?oooooooooo06Cooooo000Kooooo`03o`000?oooooooooo02_o
oooo00?o0000ooooooooool0IOooool00ol0003oooooooooo`1Uooooo`007?ooool00ol0003ooooo
ooooo`0Zooooo`03o`000?oooooooooo06Gooooo00?o0000ooooooooool0IOooool001cooooo00?o
0000ooooooooool0:_ooool00ol0003oooooooooo`1Tooooo`03o`000?oooooooooo06Kooooo000M
ooooo`03o`000?oooooooooo02Wooooo00?o0000ooooooooool0Hoooool00ol0003oooooooooo`1W
ooooo`007_ooool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo06?ooooo00?o0000oooo
ooooool0Ioooool001kooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`1Rooooo`03
o`000?oooooooooo06Sooooo000Oooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool0
H_ooool00ol0003oooooooooo`1Xooooo`007oooool00ol0003oooooooooo`0Wooooo`03o`000?oo
oooooooo067ooooo00?o0000ooooooooool0JOooool0023ooooo00?o0000ooooooooool09_ooool0
0ol0003oooooooooo`1Pooooo`03o`000?oooooooooo06[ooooo000Pooooo`03o`000?oooooooooo
02Kooooo00?o0000ooooooooool0H?ooool00ol0003oooooooooo`1Zooooo`008Oooool00ol0003o
ooooooooo`0Uooooo`03o`000?oooooooooo05oooooo00?o0000ooooooooool0Joooool0027ooooo
00?o0000ooooooooool09Oooool00ol0003oooooooooo`1Oooooo`03o`000?oooooooooo06_ooooo
000Rooooo`03o`000?oooooooooo02Cooooo00?o0000ooooooooool0G_ooool00ol0003ooooooooo
o`1/ooooo`008_ooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo05kooooo00?o0000
ooooooooool0K?ooool002?ooooo00?o0000ooooooooool08oooool00ol0003oooooooooo`1Moooo
o`03o`000?oooooooooo06gooooo000Sooooo`03o`000?oooooooooo02?ooooo00?o0000oooooooo
ool0GOooool00ol0003oooooooooo`1]ooooo`009?ooool00ol0003oooooooooo`0Rooooo`03o`00
0?oooooooooo05cooooo00?o0000ooooooooool0K_ooool002Cooooo00?o0000ooooooooool08_oo
ool00ol0003oooooooooo`1Looooo`03o`000?oooooooooo06kooooo000Uooooo`03o`000?oooooo
oooo027ooooo00?o0000ooooooooool0Foooool00ol0003oooooooooo`1_ooooo`009Oooool00ol0
003oooooooooo`0Qooooo`03o`000?oooooooooo05_ooooo00?o0000ooooooooool0Koooool002Ko
oooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`1Kooooo`03o`000?oooooooooo06oo
oooo000Vooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool0F_ooool00ol0003ooooo
ooooo`1`ooooo`009oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo05[ooooo00?o
0000ooooooooool0L?ooool002Sooooo00?o0000ooooooooool07_ooool00ol0003oooooooooo`1I
ooooo`03o`000?oooooooooo077ooooo000Xooooo`03o`000?oooooooooo01kooooo00?o0000oooo
ooooool0FOooool00ol0003oooooooooo`1aooooo`00:Oooool00ol0003oooooooooo`0Mooooo`03
o`000?oooooooooo05Sooooo00?o0000ooooooooool0L_ooool002Wooooo00?o0000ooooooooool0
7Oooool00ol0003oooooooooo`1Hooooo`03o`000?oooooooooo07;ooooo000Zooooo`03o`000?oo
oooooooo01cooooo00?o0000ooooooooool0Eoooool00ol0003oooooooooo`1cooooo`00:_ooool0
0ol0003oooooooooo`0Looooo`03o`000?oooooooooo05Oooooo00?o0000ooooooooool0Hoooool2
o`0000kooooo000[ooooo`;o00007?ooool00ol0003oooooooooo`1Fooooo`03o`000?oooooooooo
06?ooooo00Co0000oooooooooooo00003Oooool000Sooooon?l00008ooooo`03o`000?oooooooooo
00kooooo000Zooooo`Co00006oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo01_o
oooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`1Tooooo`03o`000?oooooooooo00ko
oooo000[ooooo`;o00007?ooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo01_ooooo
00?o0000ooooooooool06_ooool00ol0003oooooooooo`1Sooooo`Co00003_ooool002gooooo00?o
0000ooooooooool06Oooool00ol0003oooooooooo`1Dooooo`03o`000?oooooooooo06Gooooo00?o
0000ooooooooool03_ooool002gooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`1D
ooooo`03o`000?oooooooooo06Gooooo00?o0000ooooooooool03_ooool002kooooo00?o0000oooo
ooooool06?ooool00ol0003oooooooooo`1Cooooo`03o`000?oooooooooo07Oooooo000^ooooo`03
o`000?oooooooooo01Sooooo00?o0000ooooooooool0Doooool00ol0003oooooooooo`1gooooo`00
;oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo05;ooooo00?o0000ooooooooool0
N?ooool002oooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`1Booooo`03o`000?oo
oooooooo07Sooooo000`ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool0DOooool0
0ol0003oooooooooo`1iooooo`003_ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo
01Kooooo00?o0000ooooooooool0DOooool00ol0003oooooooooo`1iooooo`0000?oooooonk^k_nH
V9P02oooool01Ol0003oooooooooool@413oc<c<00_ooooo00?oQhN7olc<c?ooool01Oooool00onj
^[[oc<c<ooooo`08ooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0D?ooool00ol0
003oooooooooo`1jooooo`0000?ok^k^ofIVI_ooool02oooool01Ol0003ooooooooooomVIVKoMgMg
00_ooooo00?ok^k^oa0@4?ooool01_ooool00omEEEGogMgMooooo`07ooooo`03o`000?oooooooooo
01Gooooo00?o0000ooooooooool0D?ooool00ol0003oooooooooo`1jooooo`0000?oMgMgojVYZOoo
ool02Oooool01?o<c<co410@o`000?l@4102olc<c008ob4Q8Oooooooooooooooooo<c<co0000oa0@
4?o<c<`2oa0@400=olc<c?oooooo410@ob4Q8Oooooook^k^oc8b<_l0003o<S8bonk^k_ooooooc<c<
oeEEE@09ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0Coooool00ol0003ooooo
ooooo`1kooooo`0000?o8B4QomgMgOooool02Oooool02?l@413oZJVYo`000?nYZJWo410@ooooool@
413ogMgM0_ooool01ol@413o^[ZjokZj^_l0003o^[Zjolc<c?l@41001?ooool01OmEEEGoMgMgoooo
oon7QhOoIVIV00;ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Dooooo`03o`00
0?oooooooooo04oooooo00?o0000ooooooooool0Noooool00003o`000?oooooooooo00Wooooo00So
0000ooooool0003oooooo`000?ooooooEEEEoiRHV0;ooooo00Co0000oooooooooooo00000_ooool0
0ol0003oooooooooo`02ooooo`05oa0@4?o^k^koooooonk^k_l@41000_ooool00ol0003ooooooooo
o`08ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool0C_ooool00ol0003ooooooooo
o`1looooo`0000Co0000oooooooooooooooo1ol000002Ooooooo410@oiRHV?l@413oV9RHoa0@4?oo
ooooZJVYodA4A002ooooo`07oa0@4?o<c<coooooo`000?ooooooc<c<oa0@4004ooooo`05o`000?oo
ooooooooooooool000000_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01?ooooo
00?o0000ooooooooool0C_ooool00ol0003oooooooooo`1looooo`0000?o410@onk^k_ooool02Ooo
ool01Oo<c<co410@o`000?l@413oc<c<00;ooooo00[o0000oooooooooooo^[Zjoa0@4?oooooo410@
ooooool@413o^[Zj1?ooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo04gooooo00?o0000ooooooooool0
OOooool00003ogMgMonHV9Sooooo00_ooooo00?oMgMgooooooooool00_ooool00omEEEGoZJVYoooo
o`0;ooooo`08oa0@4?o^k^koooooonk^k_l@413oooooolc<c?mEEED;ooooo`03o`000?oooooooooo
01;ooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`1mooooo`0000?ok^k^oeEEEOoo
ool02oooool00omgMgOoooooooooo`02ooooo`03oiRHV?mEEEGooooo00_ooooo00SoEEEEogMgMooo
ooooQhN7oeEEEOooooooEEEEomgMg@cooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`1<ooooo`03o`000?oooooooooo07kooooo00000oooooook^k^oiRHV00;ooooo`03ogMgMooooooo
oooo00;ooooo00?ok^k^oa0@4?ooool02oooool01oo^k^ko<S8bo`000?lb<S;ok^k^ojVYZOo<c<`0
3Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo04cooooo00?o0000ooooooooool0
O_ooool003Kooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`1;ooooo`03o`000?oo
oooooooo07oooooo000fooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0B_ooool0
0ol0003oooooooooo`20ooooo`00=oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo
04[ooooo00?o0000ooooooooool0P?ooool003Sooooo00?o0000ooooooooool03_ooool00ol0003o
ooooooooo`19ooooo`03o`000?oooooooooo087ooooo000hooooo`03o`000?oooooooooo00kooooo
00?o0000ooooooooool0BOooool00ol0003oooooooooo`21ooooo`00>Oooool00ol0003ooooooooo
o`0=ooooo`03o`000?oooooooooo04Sooooo00?o0000ooooooooool0P_ooool003Wooooo00?o0000
ooooooooool03Oooool00ol0003oooooooooo`17ooooo`03o`000?oooooooooo08?ooooo000joooo
o`03o`000?oooooooooo00cooooo00?o0000ooooooooool0Aoooool00ol0003oooooooooo`23oooo
o`00>_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo04Kooooo00?o0000oooooooo
ool0Q?ooool003_ooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`16ooooo`03o`00
0?oooooooooo08Cooooo000kooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0AOoo
ool00ol0003oooooooooo`25ooooo`00??ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo04Cooooo00?o0000ooooooooool0Q_ooool003gooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`14ooooo`03o`000?oooooooooo08Kooooo000mooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool0@oooool00ol0003oooooooooo`27ooooo`00?_ooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo04?ooooo00?o0000ooooooooool0Qoooool003kooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`12ooooo`03o`000?oooooooooo08Sooooo000o
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`29
ooooo`00?oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo047ooooo00?o0000oooo
ooooool0ROooool0043ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`10ooooo`03
o`000?oooooooooo08[ooooo0011ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
?oooool00ol0003oooooooooo`2;ooooo`00@_ooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo03oooooo00?o0000ooooooooool0Roooool004;ooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`0nooooo`03o`000?oooooooooo08cooooo0013ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool0?Oooool00ol0003oooooooooo`2=ooooo`00A?ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo03gooooo00?o0000ooooooooool0SOooool004Cooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo08kooooo
0015ooooo`05o`000?ooooooooooooooool00000?Oooool00ol0003oooooooooo`2?ooooo`00A_oo
ool01?l0003oooooooooool0000mooooo`03o`000?oooooooooo08oooooo0017ooooo`03o`000?oo
oooo000003cooooo00?o0000ooooooooool0T?ooool004Oooooo00?o0000ooooool00000>oooool0
0ol0003oooooooooo`2Aooooo`00B?ooool2o`0003_ooooo00?o0000ooooooooool0TOooool004Wo
oooo00?o0000ooooooooool0>?ooool00ol0003oooooooooo`2Booooo`00BOooool00ol0003ooooo
ooooo`0gooooo`03o`000?oooooooooo09?ooooo0019ooooo`;o0000=oooool00ol0003ooooooooo
o`2Dooooo`00BOooool00ol0003oooooo`00000fooooo`03o`000?oooooooooo09Cooooo0019oooo
o`04o`000?ooooooooooo`0003Cooooo00?o0000ooooooooool0UOooool004Wooooo00Co0000oooo
oooooooo0000<oooool00ol0003oooooooooo`2Fooooo`00BOooool01Ol0003ooooooooooooooooo
0000037ooooo00?o0000ooooooooool0Uoooool004Wooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`0]ooooo`03o`000?oooooooooo09Sooooo0019ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool0;?ooool00ol0003oooooooooo`2Hooooo`00BOooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo02[ooooo00?o0000ooooooooool0VOooool004Wooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo09[ooooo0019
ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool09_ooool00ol0003oooooooooo`2K
ooooo`00BOooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo02Cooooo00?o0000oooo
ooooool0W?ooool004Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Rooooo`03
o`000?oooooooooo09gooooo0019ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
8?ooool00ol0003oooooooooo`2Nooooo`00BOooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo01kooooo00?o0000ooooooooool0Woooool004Wooooo00?o0000ooooooooool02oooool0
0ol0003oooooooooo`0Kooooo`;o0000X_ooool004Wooooo00?o0000ooooooooool03?ooool3o`00
01Sooooo0_l0002Tooooo`00BOooool00ol0003oooooooooo`0?ooooo`;o00005Oooool00ol0003o
ooooooooo`2Tooooo`00BOooool00ol0003oooooooooo`0Aooooo`;o00004Oooool2o`000:Oooooo
000nooooo`;o000000Coooooo`000?l0003o00001Oooool00ol0003oooooooooo`0Cooooo`03o`00
0?oooooooooo00_ooooo0ol0002Yooooo`00?_ooool01Ol0003ooooooooooooooooo000000Kooooo
00?o0000ooooooooool05?ooool4o`0000Gooooo1?l0002/ooooo`00?_ooool5o`0000Kooooo0ol0
000Hooooo`Ko0000[oooool003oooooo00?o0000ooooool000001oooool00ol0003oooooooooo`3=
ooooo`00?oooool00ol0003oooooo`000007ooooo`03o`000?oooooooooo0<gooooo0010ooooo`03
o`000?oooooooooo00Kooooo00?o0000ooooooooool0cOooool003oooooo0_l0003Hooooo`00oooo
oolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooo
oolJooooo`00oooooolJooooo`00oooooolJooooo`00?Oooool4o`0000?ooooo0ol00003ooooo`03
o`000?oooooo000000;ooooo0ol000000ooooooo0000o`000034ooooo`00?_ooool01_l0003ooooo
ooooool0003oooooo`0000?ooooo00Ko0000oooooooooooo0000ooooool00003ooooo`04o`000?oo
ooooooooo`000<Gooooo000nooooo`06o`000?ooooooooooo`000?oooooo00000oooool01ol0003o
ooooo`000?oooooo0000ooooool000000_ooool01?l0003oooooooooool00035ooooo`00?_ooool0
1_l0003oooooooooool0003oooooo`0000?ooooo00Oo0000ooooool0003oooooo`000?oooooo0000
00;ooooo00Co0000oooooooooooo0000aOooool003kooooo00Co0000oooooooooooo00000_ooool3
o`0000;ooooo2_l00036ooooo`00?_ooool01?l0003oooooooooool0003Gooooo`00?Oooool4o`00
0=Sooooo003ooooooa[ooooo003ooooooa[ooooo0000\
\>"],
  ImageRangeCache->{{{0, 280.812}, {173.188, 0}} -> {-1.96364, -1.08257, \
0.0267115, 0.0137574}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 6.3 M", "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"soln", "=", 
      RowBox[{"DSolve", "[", 
        RowBox[{
          RowBox[{"{", 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    SuperscriptBox["x", "\[DoublePrime]",
                      MultilineFunction->None], "[", "t", "]"}], 
                  "+", \(25\ x[t]\)}], "==", "0"}], ",", \(x[0] == 1\/3\), 
              ",", 
              RowBox[{
                RowBox[{
                  SuperscriptBox["x", "\[Prime]",
                    MultilineFunction->None], "[", "0", "]"}], 
                "==", \(-\(5\/4\)\)}]}], "}"}], ",", \(x[t]\), ",", "t"}], 
        "]"}]}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{x[t] \[Rule] 1\/12\ \((4\ Cos[5\ t] - 3\ Sin[5\ t])\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(s2[t_] = 
      x[t] /. soln\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(1\/12\ \((4\ Cos[5\ t] - 3\ Sin[5\ t])\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[s2[t], {t, 0, 2}, 
        AxesLabel \[Rule] {"\<t\>", "\<Down\>"}];\)\)], "Input",
  AspectRatioFixed->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.309019 0.70633 [
[.2619 .29652 -9 -9 ]
[.2619 .29652 9 0 ]
[.5 .29652 -3 -9 ]
[.5 .29652 3 0 ]
[.7381 .29652 -9 -9 ]
[.7381 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[1.025 .30902 0 -6 ]
[1.025 .30902 10 6 ]
[.01131 .02649 -24 -4.5 ]
[.01131 .02649 0 4.5 ]
[.01131 .16775 -24 -4.5 ]
[.01131 .16775 0 4.5 ]
[.01131 .45029 -18 -4.5 ]
[.01131 .45029 0 4.5 ]
[.01131 .59155 -18 -4.5 ]
[.01131 .59155 0 4.5 ]
[.02381 .64303 -14 0 ]
[.02381 .64303 14 12 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .30902 m
.2619 .31527 L
s
[(0.5)] .2619 .29652 0 1 Mshowa
.5 .30902 m
.5 .31527 L
s
[(1)] .5 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(1.5)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(2)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 .02649 m
.03006 .02649 L
s
[(-0.4)] .01131 .02649 1 0 Mshowa
.02381 .16775 m
.03006 .16775 L
s
[(-0.2)] .01131 .16775 1 0 Mshowa
.02381 .45029 m
.03006 .45029 L
s
[(0.2)] .01131 .45029 1 0 Mshowa
.02381 .59155 m
.03006 .59155 L
s
[(0.4)] .01131 .59155 1 0 Mshowa
.125 Mabswid
.02381 .0618 m
.02756 .0618 L
s
.02381 .09712 m
.02756 .09712 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .20307 m
.02756 .20307 L
s
.02381 .23839 m
.02756 .23839 L
s
.02381 .2737 m
.02756 .2737 L
s
.02381 .34434 m
.02756 .34434 L
s
.02381 .37965 m
.02756 .37965 L
s
.02381 .41497 m
.02756 .41497 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .52092 m
.02756 .52092 L
s
.02381 .55623 m
.02756 .55623 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
gsave
.02381 .64303 -75 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Down) show
87.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .54446 m
.06244 .45567 L
.10458 .33231 L
.14415 .2119 L
.18221 .11147 L
.20178 .07111 L
.21267 .0529 L
.22272 .03906 L
.23293 .02806 L
.23832 .02356 L
.24402 .01978 L
.24641 .01851 L
.24897 .01735 L
.25119 .01651 L
.25361 .01578 L
.25507 .01543 L
.25643 .01517 L
.25773 .01497 L
.2584 .01489 L
.25912 .01483 L
.25983 .01477 L
.26048 .01474 L
.26176 .01472 L
.26293 .01474 L
.26416 .01481 L
.26538 .01493 L
.26671 .01512 L
.26796 .01535 L
.26912 .0156 L
.27364 .01702 L
.27598 .01801 L
.27857 .01931 L
.2838 .02259 L
.29326 .0307 L
.30213 .04081 L
.32232 .0723 L
.34082 .11052 L
.38045 .21527 L
.41855 .33134 L
.45912 .45059 L
.47785 .49829 L
.49816 .5417 L
.50927 .56108 L
.51951 .57593 L
.52929 .58724 L
.53471 .59225 L
.53966 .59602 L
.5445 .59896 L
.54909 .60106 L
.55161 .60192 L
Mistroke
.55394 .60253 L
.55529 .60281 L
.55651 .60301 L
.55718 .6031 L
.55791 .60318 L
.55923 .60328 L
.56038 .60332 L
.56145 .60332 L
.56262 .60328 L
.56388 .60318 L
.56519 .60303 L
.56644 .60283 L
.56878 .60232 L
.57096 .60169 L
.57298 .60097 L
.57755 .59885 L
.58219 .59601 L
.5872 .59219 L
.59625 .58331 L
.60701 .56953 L
.61686 .554 L
.65654 .46704 L
.6947 .35769 L
.73531 .23327 L
.77441 .12607 L
.79436 .08213 L
.80486 .06288 L
.81596 .04579 L
.82589 .03352 L
.83116 .02822 L
.8368 .02349 L
.84199 .02003 L
.84673 .01762 L
.849 .01672 L
.85148 .01592 L
.85262 .01563 L
.85383 .01536 L
.85495 .01515 L
.856 .01499 L
.85713 .01486 L
.85837 .01476 L
.85958 .01472 L
.86087 .01472 L
.86208 .01478 L
.86322 .01487 L
.86424 .01499 L
.86535 .01516 L
.8679 .0157 L
.8706 .01649 L
.87544 .01851 L
Mistroke
.87993 .02106 L
.88414 .02402 L
.89371 .03283 L
.9041 .04555 L
.91398 .06053 L
.93251 .0957 L
.97072 .19183 L
.97619 .20753 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.812, 174.188},
  ImageMargins->{{17, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000[R000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`006oooool00ol0003oooooooooo`3kooooo`006ooo
ool00ol0003oooooooooo`3kooooo`006oooool00ol0003oooooooooo`3kooooo`006oooool00ol0
003oooooooooo`0dooooo`Go0000SOooool5o`00033ooooo0008ooooo`;o00001?ooool00ol0003o
ooooooooo`03ooooo`?o00001?ooool00ol0003oooooooooo`0booooo`?o00001?ooool3o`0008Oo
oooo0ol00005ooooo`;o0000;_ooool000Oooooo00Co0000oooooooooooo00002_ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo033ooooo0_l0000:ooooo`03o`000?oooooooooo08?o
oooo00?o0000ooooooooool02?ooool2o`0002cooooo0005o`0000;ooooo00Co0000oooooooooooo
00001oooool5o`0000Cooooo0_l0000`ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool0POooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo02[ooooo0007ooooo`04o`00
0?ooooooooooo`0000Oooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`0_oooo
o`03o`000?oooooooooo00cooooo00?o0000ooooooooool0P?ooool00ol0003oooooooooo`0;oooo
o`03o`000?oooooooooo02Wooooo0007ooooo`04o`000?ooooooooooo`0000Sooooo00?o0000oooo
ool000001Oooool00ol0003oooooooooo`0^ooooo`03o`000?oooooooooo00gooooo00?o0000oooo
ooooool0Ooooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo02Sooooo0007ooooo`04
o`000?ooooooooooo`0000Wooooo0_l00005ooooo`03o`000?oooooooooo02gooooo00?o0000oooo
ooooool03oooool00ol0003oooooooooo`1mooooo`03o`000?oooooooooo00oooooo00?o0000oooo
ooooool09oooool000Sooooo0_l0000;ooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool0;Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo07_ooooo00?o0000oooooooo
ool04Oooool00ol0003oooooooooo`0Vooooo`006oooool00ol0003oooooooooo`0/ooooo`03o`00
0?oooooooooo017ooooo00?o0000ooooooooool0N_ooool00ol0003oooooooooo`0Cooooo`03o`00
0?oooooooooo02Gooooo000Kooooo`03o`000?oooooooooo02cooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`1iooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool09Ooo
ool001_ooooo00?o0000ooooooooool0:oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooo
oooo07Oooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`0Tooooo`006oooool00ol0
003oooooooooo`0[ooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0M_ooool00ol0
003oooooooooo`0Fooooo`03o`000?oooooooooo02?ooooo000Kooooo`03o`000?oooooooooo02[o
oooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`1eooooo`03o`000?oooooooooo01Oo
oooo00?o0000ooooooooool08oooool001_ooooo00?o0000ooooooooool0:Oooool00ol0003ooooo
ooooo`0Hooooo`03o`000?oooooooooo07Cooooo00?o0000ooooooooool06?ooool00ol0003ooooo
ooooo`0Rooooo`006oooool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo01[ooooo00?o
0000ooooooooool0L_ooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo02;ooooo000K
ooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`1a
ooooo`03o`000?oooooooooo01_ooooo00?o0000ooooooooool08Oooool001_ooooo00?o0000oooo
ooooool09oooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo073ooooo00?o0000oooo
ooooool07?ooool00ol0003oooooooooo`0Pooooo`006oooool00ol0003oooooooooo`0Wooooo`03
o`000?oooooooooo01cooooo00?o0000ooooooooool0Koooool00ol0003oooooooooo`0Mooooo`03
o`000?oooooooooo023ooooo000Kooooo`03o`000?oooooooooo02Kooooo00?o0000ooooooooool0
7_ooool00ol0003oooooooooo`1^ooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool0
7oooool001_ooooo00?o0000ooooooooool09_ooool00ol0003oooooooooo`0Nooooo`03o`000?oo
oooooooo06gooooo00?o0000ooooooooool07oooool00ol0003oooooooooo`0Oooooo`006oooool0
0ol0003oooooooooo`0Uooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool0K?ooool0
0ol0003oooooooooo`0Pooooo`03o`000?oooooooooo01kooooo000Kooooo`03o`000?oooooooooo
02Gooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`1[ooooo`03o`000?oooooooooo
027ooooo00?o0000ooooooooool07_ooool001_ooooo00?o0000ooooooooool09?ooool00ol0003o
ooooooooo`0Rooooo`03o`000?oooooooooo06[ooooo00?o0000ooooooooool08_ooool00ol0003o
ooooooooo`0Mooooo`006oooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo02;ooooo
00?o0000ooooooooool0JOooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo01gooooo
000Kooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool09?ooool00ol0003ooooooooo
o`1Xooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool07Oooool001_ooooo00?o0000
ooooooooool08oooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo06Oooooo00?o0000
ooooooooool09Oooool00ol0003oooooooooo`0Looooo`006oooool00ol0003oooooooooo`0Roooo
o`03o`000?oooooooooo02Kooooo00?o0000ooooooooool0I_ooool00ol0003oooooooooo`0Uoooo
o`03o`000?oooooooooo01cooooo000Kooooo`03o`000?oooooooooo02;ooooo00?o0000oooooooo
ool09_ooool00ol0003oooooooooo`1Uooooo`03o`000?oooooooooo02Oooooo00?o0000oooooooo
ool06oooool001_ooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`0Vooooo`03o`00
0?oooooooooo06Gooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`0Kooooo`006ooo
ool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool0Hooo
ool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo01_ooooo000Kooooo`03o`000?oooooo
oooo027ooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`1Sooooo`03o`000?oooooo
oooo02Wooooo00?o0000ooooooooool06_ooool001_ooooo00?o0000ooooooooool08Oooool00ol0
003oooooooooo`0Xooooo`03o`000?oooooooooo06?ooooo00?o0000ooooooooool0:Oooool00ol0
003oooooooooo`0Jooooo`006oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo02[o
oooo00?o0000ooooooooool0HOooool00ol0003oooooooooo`0[ooooo`03o`000?oooooooooo01Wo
oooo000Kooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool0:_ooool00ol0003ooooo
ooooo`1Qooooo`03o`000?oooooooooo02_ooooo00?o0000ooooooooool06Oooool001_ooooo00?o
0000ooooooooool07oooool00ol0003oooooooooo`0[ooooo`03o`000?oooooooooo067ooooo00?o
0000ooooooooool0:oooool00ol0003oooooooooo`0Iooooo`002?ooool2o`0000Cooooo00Co0000
oooooooooooooooo1Ol00004ooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool0;?oo
ool00ol0003oooooooooo`1Oooooo`03o`000?oooooooooo02gooooo00?o0000ooooooooool06?oo
ool000Oooooo00Co0000oooooooooooo00002?ooool01?l0003oooooooooool00004ooooo`03o`00
0?oooooooooo01oooooo00?o0000ooooooooool0;?ooool00ol0003oooooooooo`1Oooooo`03o`00
0?oooooooooo02gooooo00?o0000ooooooooool06?ooool000Go00000_ooool01?l0003ooooooooo
ool00009ooooo`03o`000?oooooooooo00Cooooo0_l0000Oooooo`03o`000?oooooooooo02kooooo
00?o0000ooooooooool0G_ooool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo01Sooooo
0007ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`0Nooooo`03o`000?oooooooooo02kooooo00?o0000ooooooooool0GOooool00ol0003ooooo
ooooo`0_ooooo`03o`000?oooooooooo01Oooooo0007ooooo`04o`000?ooooooooooo`0000Oooooo
00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo01kooooo00?o0000oooooooo
ool0;_ooool00ol0003oooooooooo`1Mooooo`03o`000?oooooooooo02oooooo00?o0000oooooooo
ool05oooool000Oooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo0000
00Cooooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`0`ooooo`03o`000?oooooooooo
05cooooo00?o0000ooooooooool0<?ooool00ol0003oooooooooo`0Fooooo`002?ooool2o`0000Wo
oooo0ol00005ooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool0<?ooool00ol0003o
ooooooooo`1Kooooo`03o`000?oooooooooo037ooooo00?o0000ooooooooool05_ooool001_ooooo
00?o0000ooooooooool07?ooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo05_ooooo
00?o0000ooooooooool0<Oooool00ol0003oooooooooo`0Fooooo`006oooool00ol0003ooooooooo
o`0Looooo`03o`000?oooooooooo03;ooooo00?o0000ooooooooool0F_ooool00ol0003ooooooooo
o`0booooo`03o`000?oooooooooo01Gooooo000Kooooo`03o`000?oooooooooo01cooooo00?o0000
ooooooooool0<_ooool00ol0003oooooooooo`1Iooooo`03o`000?oooooooooo03?ooooo00?o0000
ooooooooool05Oooool001_ooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`0coooo
o`03o`000?oooooooooo05Wooooo00?o0000ooooooooool0<oooool00ol0003oooooooooo`0Eoooo
o`006oooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo03Cooooo00?o0000oooooooo
ool0F?ooool00ol0003oooooooooo`0dooooo`03o`000?oooooooooo01Cooooo000Kooooo`03o`00
0?oooooooooo01_ooooo00?o0000ooooooooool0=?ooool00ol0003oooooooooo`1Gooooo`03o`00
0?oooooooooo03Gooooo00?o0000ooooooooool05?ooool001_ooooo00?o0000ooooooooool06_oo
ool00ol0003oooooooooo`0eooooo`03o`000?oooooooooo05Oooooo00?o0000ooooooooool0C?oo
ool001_ooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0fooooo`03o`000?oooooo
oooo05Kooooo00?o0000ooooooooool0C?ooool001_ooooo00?o0000ooooooooool06Oooool00ol0
003oooooooooo`0gooooo`03o`000?oooooooooo05Gooooo00?o0000ooooooooool0COooool001_o
oooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`0hooooo`03o`000?oooooooooo05Co
oooo00?o0000ooooooooool0COooool001_ooooo00?o0000ooooooooool06Oooool00ol0003ooooo
ooooo`0hooooo`03o`000?oooooooooo05Cooooo00?o0000ooooooooool0COooool001_ooooo00?o
0000ooooooooool06?ooool00ol0003oooooooooo`0iooooo`03o`000?oooooooooo05?ooooo00?o
0000ooooooooool0C_ooool001_ooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0j
ooooo`03o`000?oooooooooo05;ooooo00?o0000ooooooooool0C_ooool001_ooooo00?o0000oooo
ooooool06?ooool00ol0003oooooooooo`0jooooo`03o`000?oooooooooo05;ooooo00?o0000oooo
ooooool0C_ooool001_ooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0kooooo`03
o`000?oooooooooo057ooooo00?o0000ooooooooool0Coooool001_ooooo00?o0000ooooooooool0
5oooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo053ooooo00?o0000ooooooooool0
Coooool001_ooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0looooo`03o`000?oo
oooooooo053ooooo00?o0000ooooooooool0Coooool001_ooooo00?o0000ooooooooool05_ooool0
0ol0003oooooooooo`0mooooo`03o`000?oooooooooo04oooooo00?o0000ooooooooool0D?ooool0
01_ooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`0nooooo`03o`000?oooooooooo
04kooooo00?o0000ooooooooool0D?ooool001_ooooo00?o0000ooooooooool05_ooool00ol0003o
ooooooooo`0Gooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`?o00006Oooool00ol0003o
ooooooooo`0Dooooo`?o0000<Oooool3o`0000?ooooo0_l00004ooooo`?o0000<?ooool5o`0001Go
oooo000Kooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool05oooool01?l0003ooooo
ooooool00007ooooo`05o`000?ooooooooooooooool000006?ooool00ol0003oooooooooo`0Eoooo
o`03o`000?oooooooooo037ooooo00Go0000ooooooooooooooooo`000005ooooo`05o`000?oooooo
ooooooooool00000<?ooool01?l0003oooooooooool0000Eooooo`006oooool00ol0003ooooooooo
o`0Eooooo`03o`000?oooooooooo01Oooooo00Co0000oooooooooooo00002oooool00ol0003ooooo
ooooo`0Gooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0<Oooool01Ol0003ooooo
oooooooooooo000000Wooooo00?o0000ooooooooool0;oooool00ol0003oooooooooo`0Eooooo`00
6oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo01Oooooo00Co0000oooooooooooo
00002oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo01Cooooo00?o0000oooooooo
ool0<Oooool01Ol0003ooooooooooooooooo000000Wooooo00?o0000ooooooooool0<?ooool00ol0
003oooooooooo`0Dooooo`006oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo01So
oooo00Co0000oooooooooooo00001oooool4o`0001_ooooo00?o0000ooooooooool04oooool00ol0
003oooooooooo`0aooooo`04o`000?ooooooooooo`0000Kooooo1?l0000`ooooo`05o`000?oooooo
ooooooooool000005Oooool001_ooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0H
ooooo`04o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool07?ooool00ol0003ooooooooo
o`0Booooo`;o0000<_ooool2o`0000;ooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`0aooooo`05o`000?ooooooooooooooool000005Oooool001_ooooo00?o0000ooooooooool05?oo
ool00ol0003oooooooooo`0Iooooo`;o00002?ooool5o`0001[ooooo00?o0000ooooooooool04ooo
ool00ol0003oooooooooo`0aooooo`04o`000?ooooooooooo`0000Kooooo1Ol0000`ooooo`?o0000
5_ooool001_ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`14ooooo`03o`000?oo
oooooooo04Sooooo00?o0000ooooooooool0Doooool001_ooooo00?o0000ooooooooool04oooool0
0ol0003oooooooooo`14ooooo`03o`000?oooooooooo04Sooooo00?o0000ooooooooool0Doooool0
01_ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`14ooooo`03o`000?oooooooooo
04Sooooo00?o0000ooooooooool0C?ooool2o`0000Gooooo000Kooooo`03o`000?oooooooooo01;o
oooo00?o0000ooooooooool0A_ooool00ol0003oooooooooo`16ooooo`03o`000?oooooooooo04co
oooo00Co0000oooooooooooo00001?ooool001Gooooom?l00008ooooo`03o`000?oooooooooo00Go
oooo000Kooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool01oooool00ol0003ooooo
o`00000:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02Oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003ooooo
o`000009ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool02Oooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool02Oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool01Oooool001_ooooo00?o
0000ooooooooool04Oooool00ol0003oooooooooo`18ooooo`03o`000?oooooooooo04Cooooo00?o
0000ooooooooool0C?ooool4o`0000Gooooo000Kooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool0B?ooool00ol0003oooooooooo`14ooooo`03o`000?oooooooooo04gooooo00?o0000
ooooooooool01Oooool001_ooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`18oooo
o`03o`000?oooooooooo04Cooooo00?o0000ooooooooool0COooool00ol0003oooooooooo`05oooo
o`006oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo04[ooooo00?o0000oooooooo
ool0@_ooool00ol0003oooooooooo`1Fooooo`006oooool00ol0003oooooooooo`0@ooooo`03o`00
0?oooooooooo04[ooooo00?o0000ooooooooool0@_ooool00ol0003oooooooooo`1Fooooo`006ooo
ool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo04_ooooo00?o0000ooooooooool0@Ooo
ool00ol0003oooooooooo`1Fooooo`006oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooo
oooo04cooooo00?o0000ooooooooool0@?ooool00ol0003oooooooooo`1Gooooo`006oooool00ol0
003oooooooooo`0?ooooo`03o`000?oooooooooo04cooooo00?o0000ooooooooool0@?ooool00ol0
003oooooooooo`1Gooooo`006oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo04go
oooo00?o0000ooooooooool0?oooool00ol0003oooooooooo`1Gooooo`006oooool00ol0003ooooo
ooooo`0>ooooo`03o`000?oooooooooo04kooooo00?o0000ooooooooool0?_ooool00ol0003ooooo
ooooo`1Hooooo`006oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo04kooooo00?o
0000ooooooooool0?_ooool00ol0003oooooooooo`1Hooooo`006oooool00ol0003oooooooooo`0>
ooooo`03o`000?oooooooooo04oooooo00?o0000ooooooooool0?Oooool00ol0003oooooooooo`1H
ooooo`006oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo053ooooo00?o0000oooo
ooooool0??ooool00ol0003oooooooooo`1Iooooo`006oooool00ol0003oooooooooo`0=ooooo`03
o`000?oooooooooo053ooooo00?o0000ooooooooool0??ooool00ol0003oooooooooo`1Iooooo`00
6oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo057ooooo00?o0000ooooooooool0
>oooool00ol0003oooooooooo`1Iooooo`006oooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo05;ooooo00?o0000ooooooooool0>_ooool00ol0003oooooooooo`1Jooooo`006oooool0
0ol0003oooooooooo`0<ooooo`03o`000?oooooooooo05;ooooo00?o0000ooooooooool0>_ooool0
0ol0003oooooooooo`1Jooooo`006oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
05?ooooo00?o0000ooooooooool0>Oooool00ol0003oooooooooo`1Jooooo`006oooool00ol0003o
ooooooooo`0;ooooo`03o`000?oooooooooo05Cooooo00?o0000ooooooooool0>?ooool00ol0003o
ooooooooo`1Kooooo`006oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo05Cooooo
00?o0000ooooooooool0>?ooool00ol0003oooooooooo`1Kooooo`006oooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo05Gooooo00?o0000ooooooooool0=oooool00ol0003ooooooooo
o`1Kooooo`006oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo05Kooooo00?o0000
ooooooooool0=_ooool00ol0003oooooooooo`1Looooo`006oooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo05Kooooo00?o0000ooooooooool0=_ooool00ol0003oooooooooo`1Loooo
o`006oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo05Oooooo00?o0000oooooooo
ool0=Oooool00ol0003oooooooooo`1Looooo`006oooool00ol0003oooooooooo`09ooooo`03o`00
0?oooooooooo05Sooooo00?o0000ooooooooool0=?ooool00ol0003oooooooooo`1Mooooo`006ooo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo05Sooooo00?o0000ooooooooool0=?oo
ool00ol0003oooooooooo`1Mooooo`006oooool00ol0003oooooooooo`09ooooo`03o`000?oooooo
oooo05Wooooo00?o0000ooooooooool0<oooool00ol0003oooooooooo`1Mooooo`006oooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo05[ooooo00?o0000ooooooooool0<_ooool00ol0
003oooooooooo`1Nooooo`006oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo05[o
oooo00?o0000ooooooooool0<_ooool00ol0003oooooooooo`1Nooooo`006oooool00ol0003ooooo
ooooo`08ooooo`03o`000?oooooooooo05_ooooo00?o0000ooooooooool0<Oooool00ol0003ooooo
ooooo`1Nooooo`002?ooool2o`0000Cooooo00Co0000oooooooooooooooo1Ol00004ooooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool0G?ooool00ol0003oooooooooo`0`ooooo`03o`00
0?oooooooooo05oooooo0007ooooo`04o`000?ooooooooooo`0000Sooooo00Co0000oooooooooooo
00001?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo05cooooo00?o0000oooooooo
ool0<?ooool00ol0003oooooooooo`1Oooooo`001oooool01?l0003oooooooooool00009ooooo`03
o`000?oooooooooo00Cooooo0_l00008ooooo`03o`000?oooooooooo05gooooo00?o0000oooooooo
ool0;oooool00ol0003oooooooooo`1Oooooo`001oooool01?l0003oooooooooool0000:ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`1Nooooo`03
o`000?oooooooooo02kooooo00?o0000ooooooooool0H?ooool000Oooooo00Co0000oooooooooooo
00001oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool01_ooool00ol0
003oooooooooo`1Oooooo`03o`000?oooooooooo02gooooo00?o0000ooooooooool0H?ooool000Oo
oooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000
ooooooooool01_ooool00ol0003oooooooooo`1Oooooo`03o`000?oooooooooo02gooooo00?o0000
ooooooooool0H?ooool000Sooooo0_l00009ooooo`?o00001Oooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo063ooooo00?o0000ooooooooool0;?ooool00ol0003oooooooooo`1Qoooo
o`006oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo067ooooo00?o0000oooooooo
ool0:oooool00ol0003oooooooooo`1Qooooo`006oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo06;ooooo00?o0000ooooooooool0:_ooool00ol0003oooooooooo`1Rooooo`006ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo06;ooooo00?o0000ooooooooool0:_oo
ool00ol0003oooooooooo`1Rooooo`006oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo06?ooooo00?o0000ooooooooool0:?ooool00ol0003oooooooooo`1Sooooo`006oooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo06Cooooo00?o0000ooooooooool0:?ooool00ol0
003oooooooooo`1Sooooo`006oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo06Co
oooo00?o0000ooooooooool09oooool00ol0003oooooooooo`1Tooooo`006oooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo06Kooooo00?o0000ooooooooool09_ooool00ol0003ooooo
ooooo`1Tooooo`006oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo06Kooooo00?o
0000ooooooooool09_ooool00ol0003oooooooooo`1Tooooo`006oooool01Ol0003ooooooooooooo
oooo000006Wooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`1Uooooo`006oooool0
1Ol0003ooooooooooooooooo000006[ooooo00?o0000ooooooooool09?ooool00ol0003ooooooooo
o`1Uooooo`006oooool01Ol0003ooooooooooooooooo000006[ooooo00?o0000ooooooooool08ooo
ool00ol0003oooooooooo`1Vooooo`006oooool01?l0003oooooooooool0001/ooooo`03o`000?oo
oooooooo02;ooooo00?o0000ooooooooool0I_ooool001_ooooo00Co0000oooooooooooo0000K?oo
ool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo06Oooooo000Kooooo`03o`000?oooooo
000006kooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`1Wooooo`006oooool00ol0
003oooooo`00001^ooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool0J?ooool001_o
oooo0_l0001_ooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool0J?ooool001_ooooo
0_l0001`ooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool0JOooool001_ooooo0_l0
001`ooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool0JOooool001_ooooo00?o0000
ooooooooool0L?ooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo06Wooooo000Koooo
o`03o`000?oooooooooo073ooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`1Zoooo
o`006oooool00ol0003oooooooooo`1aooooo`03o`000?oooooooooo01[ooooo00?o0000oooooooo
ool0J_ooool001_ooooo00?o0000ooooooooool0L_ooool00ol0003oooooooooo`0Hooooo`03o`00
0?oooooooooo06_ooooo000Kooooo`03o`000?oooooooooo07?ooooo00?o0000ooooooooool05ooo
ool00ol0003oooooooooo`1[ooooo`006oooool00ol0003oooooooooo`1cooooo`03o`000?oooooo
oooo01Kooooo00?o0000ooooooooool0K?ooool001_ooooo00?o0000ooooooooool0M?ooool00ol0
003oooooooooo`0Dooooo`03o`000?oooooooooo06gooooo000Kooooo`03o`000?oooooooooo07Co
oooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`1]ooooo`006oooool00ol0003ooooo
ooooo`1eooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0K_ooool000Sooooo0_l0
0004ooooo`03o`000?oooooooooo00?ooooo0ol00004ooooo`03o`000?oooooooooo07Kooooo00?o
0000ooooooooool04?ooool00ol0003oooooooooo`1_ooooo`001oooool01?l0003oooooooooool0
000:ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Moooool00ol0003ooooooooo
o`0>ooooo`03o`000?oooooooooo073ooooo0007ooooo`04o`000?ooooooooooo`0000Oooooo1Ol0
0004ooooo`03o`000?oooooooooo07Sooooo00?o0000ooooooooool03?ooool00ol0003ooooooooo
o`1aooooo`001oooool01?l0003oooooooooool00007ooooo`04o`000?ooooooooooo`0000Gooooo
0_l0001jooooo`03o`000?oooooooooo00Wooooo0_l0001dooooo`001oooool01?l0003ooooooooo
ool00008ooooo`03o`000?oooooo000000Gooooo00?o0000ooooooooool0N_ooool2o`0000Oooooo
0_l0001fooooo`001oooool01?l0003oooooooooool00009ooooo`;o00001Oooool00ol0003ooooo
ooooo`1looooo`Oo0000N?ooool000Sooooo0_l0000;ooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool0Ooooool2o`0007[ooooo000Kooooo`03o`000?oooooooooo0?_ooooo000Koooo
o`03o`000?oooooooooo0?_ooooo000Kooooo`03o`000?oooooooooo0?_ooooo003ooooooa[ooooo
003ooooooa[ooooo003ooooooa[ooooo003ooooooa[ooooo003ooooooa[ooooo003ooooooa[ooooo
003ooooooa[ooooo003ooooooa[ooooo003ooooooa[ooooo000?ooooo`Co00000oooool3o`0000?o
oooo00?o0000ooooool000000_ooool3o`000003ooooool0003o00000?;ooooo000@ooooo`06o`00
0?ooooooooooo`000?oooooo00000oooool01_l0003oooooooooool0003oooooo`0000?ooooo00Co
0000oooooooooooo0000loooool0013ooooo00Ko0000oooooooooooo0000ooooool00003ooooo`07
o`000?oooooo0000ooooool0003oooooo`000002ooooo`04o`000?ooooooooooo`000??ooooo000@
ooooo`06o`000?ooooooooooo`000?oooooo00000oooool01ol0003oooooo`000?oooooo0000oooo
ool000000_ooool01?l0003oooooooooool0003cooooo`004?ooool01?l0003oooooooooool00002
ooooo`?o00000_ooool:o`000?Cooooo000@ooooo`04o`000?ooooooooooo`000?oooooo1_ooool0
00oooooo1?l0003oooooo`Oooooo003ooooooa[ooooo003ooooooa[ooooo003ooooooa[ooooo003o
oooooa[ooooo0000\
\>"],
  ImageRangeCache->{{{0, 280.812}, {173.188, 0}} -> {-0.233261, -0.450945, \
0.00862506, 0.0058148}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[1\/5\ \((\[Pi] - ArcTan[\(-\(4\/3\)\)])\)]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(0.8137775743182811`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      SuperscriptBox["s2", "\[Prime]",
        MultilineFunction->None], "[", "%", "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(2.0833333333333335`\)], "Output"]
}, Open  ]]
}, Closed]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{520, 365},
WindowMargins->{{28, Automatic}, {15, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 96, 2, 65, "Subtitle",
  Evaluatable->False],
Cell[1853, 55, 159, 5, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2037, 64, 80, 2, 56, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2142, 70, 677, 17, 43, "Input"],
Cell[2822, 89, 63, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2922, 95, 130, 3, 27, "Input"],
Cell[3055, 100, 46, 1, 27, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[3150, 107, 81, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3256, 113, 696, 18, 62, "Input"],
Cell[3955, 133, 71, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4063, 139, 130, 3, 27, "Input"],
Cell[4196, 144, 54, 1, 42, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[4299, 151, 104, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4428, 157, 348, 6, 96, "Input"],
Cell[4779, 165, 22439, 542, 183, 7760, 355, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[27255, 712, 273, 6, 126, "Input"],
Cell[27531, 720, 26635, 660, 183, 10417, 454, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[54215, 1386, 81, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[54321, 1392, 718, 19, 80, "Input"],
Cell[55042, 1413, 91, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[55170, 1419, 130, 3, 27, "Input"],
Cell[55303, 1424, 74, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[55414, 1430, 137, 3, 27, "Input"],
Cell[55554, 1435, 28749, 668, 183, 6967, 393, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[84340, 2108, 104, 2, 42, "Input"],
Cell[84447, 2112, 53, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[84537, 2118, 153, 4, 27, "Input"],
Cell[84693, 2124, 53, 1, 27, "Output"]
}, Open  ]]
}, Closed]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

